function [model] = plda_train(model,data,labels)
% Sort by the number of samples per source
ulab=unique(labels);

no_of_instances=[]; data_per_source={};

for i=1:length(ulab)
    count=0;mat=[];
    for j=1:length(labels)
        if labels(j)==ulab(i)
            count=count+1;
            mat=[mat; data(j,:)];
        end
        no_of_instances(i)=count;
        data_per_source{i}=mat;
    end
end
[B I]=sort(no_of_instances);

data_per_source_sorted={};
for i=1:length(I)
  data_per_source_sorted{i}=data_per_source{I(i)};
end

dimension= size(data_per_source{1},2);

pooled_data= cell2mat(data_per_source_sorted');

num_samples=size(pooled_data,1);

model.mu=mean(pooled_data,1);

%center data in case it has not been gaussianized before
 for i=1:length(data_per_source_sorted)
     data_per_source_sorted{i}= transpose(data_per_source_sorted{i}-model.mu);
 end
     pooled_data = transpose(pooled_data - model.mu);

    num_sources = length(data_per_source_sorted);
    zeroth_order_moment = num_samples;
   first_order_moment = zeros([dimension, num_sources]);
   
   for i=1:num_sources
       first_order_moment(:,i)= sum(data_per_source_sorted{i},2);
   end
        second_order_moment =pooled_data.*transpose(pooled_data);

    %initialize
       model.invB = second_order_moment / zeroth_order_moment;
       model.invW = second_order_moment / zeroth_order_moment;

    % run EM-algorithm
       for m=1:1000

            % E-step
            b = inv(model.invB);
            w =inv(model.invW);
            t = zeros([dimension, dimension]);
            r = zeros([dimension, dimension]);
            y = zeros([dimension,1]);
            bmu = b*model.mu;
            num_samples_of_previous_source = 0;
            
            for k=1:num_sources
                num_samples=size(data_per_source_sorted{k},2);
                if num_samples ~=num_samples_of_previous_source
                    invl_i=inv(b+num_samples*w);
                    num_samples_of_previous_source = num_samples;
                end
            
                ey_i = invl_i.*(bmu + w.*first_order_moment(:, k));
                t = t + OuterProduct(ey_i, first_order_moment(:, index_source));
                r = r + num_samples * (invl_i + OuterProduct(ey_i, ey_i));
                y = y + num_samples * ey_i;
            end

           % M-step
            model.mu = y / zeroth_order_moment;
            model.invB = (r - OuterProduct(model.mu, transpose(y)) - OuterProduct(y, model.mu)) / zeroth_order_moment + OuterProduct(model.mu, model.mu);
            model.invW = (second_order_moment - t - transpose(t) + r) / zeroth_order_moment;
       end
end
       

   


